<?php  
include('connection.php');
session_start();

// Ensure the user is logged in
if (!isset($_SESSION['admin_login'])) {
    echo '<script>window.location="login.php";</script>';
    exit;
}

$admin_username = $_SESSION['admin_login']; // Teacher's username

// Handle search by registration number or full name
$registration_number = isset($_GET['registration_number']) ? $_GET['registration_number'] : '';
$full_name = isset($_GET['full_name']) ? $_GET['full_name'] : '';

// Handle search filters
$exam_type = isset($_GET['exam_type']) ? $_GET['exam_type'] : '';
$class = isset($_GET['class']) ? $_GET['class'] : '';
$year = isset($_GET['year']) ? $_GET['year'] : '';

// Generate SQL conditions based on filters
$filterConditions = [];
if (!empty($exam_type)) {
    $filterConditions[] = "exam_type = '$exam_type'";
}
if (!empty($class)) {
    $filterConditions[] = "class = '$class'";
}
if (!empty($year)) {
    $filterConditions[] = "year = '$year'";
}

// Combine filters into a WHERE clause
$filterSQL = !empty($filterConditions) ? ' AND ' . implode(' AND ', $filterConditions) : '';

// Subjects and corresponding tables
$subjects = [
    'Mathematics' => 'mathematics',
    'English' => 'english',
    'Kiswahili' => 'kiswahili',
    'Physics' => 'physics',
    'Chemistry' => 'chemistry',
    'Biology' => 'biology',
    'Geography' => 'geography',
    'History' => 'history',
    'Civics' => 'civics',
    'French' => 'french',
    'Literature' => 'literature'
];

// Grade and points logic
$gradeScale = [
    'A' => [75, 100, 1],
    'B' => [65, 74, 2],
    'C' => [45, 64, 3],
    'D' => [30, 44, 4],
    'F' => [0, 29, 5]
];

// Function to calculate grade and points
function calculateGrade($score, $gradeScale) {
    foreach ($gradeScale as $grade => $range) {
        if ($score >= $range[0] && $score <= $range[1]) {
            return [$grade, $range[2]]; // Return grade and points
        }
    }
    return ['N/A', 0]; // If no score, return N/A and 0 points
}

// Function to calculate division based on total points
function calculateDivision($points) {
    if ($points >= 7 && $points <= 17) {
        return "I";
    } elseif ($points >= 18 && $points <= 21) {
        return "II";
    } elseif ($points >= 22 && $points <= 25) {
        return "III";
    } elseif ($points >= 26 && $points <= 33) {
        return "IV";
    } else {
        return "0";
    }
}

// Fetch student details based on the registration number or full name
if (!empty($registration_number) || !empty($full_name)) {
    $studentQuery = !empty($registration_number)
        ? "SELECT full_name, gender, registration_number FROM students WHERE registration_number = ?"
        : "SELECT full_name, gender, registration_number FROM students WHERE full_name LIKE CONCAT('%', ?, '%')";
    
    $stmt = $con->prepare($studentQuery);
    if ($stmt === false) {
        die('Error preparing the query: ' . $con->error);
    }
    
    $param = !empty($registration_number) ? $registration_number : $full_name;
    $stmt->bind_param('s', $param);
    $stmt->execute();
    $studentDetails = $stmt->get_result()->fetch_assoc();

    if (!$studentDetails) {
        echo '<div class="alert alert-danger">Student not found.</div>';
        exit;
    }

    // Fetch results for each subject with filters and calculate total, average, points, etc.
    $totalScore = 0;
    $pointsArray = [];
    $studentResults = [];
    $resultsFound = false;

    foreach ($subjects as $subject_name => $table_name) {
        $subjectQuery = "SELECT score FROM $table_name WHERE registration_number = ?" . $filterSQL;
        $stmt = $con->prepare($subjectQuery);
        if ($stmt === false) {
            die('Error preparing the query: ' . $con->error);
        }
        $stmt->bind_param('s', $studentDetails['registration_number']);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $score = $result->fetch_assoc()['score'];
            list($grade, $points) = calculateGrade($score, $gradeScale);

            $studentResults[$subject_name] = [
                'score' => $score,
                'grade' => $grade,
                'points' => $points
            ];

            $pointsArray[] = $points;
            $totalScore += $score;
            $resultsFound = true;
        } else {
            $studentResults[$subject_name] = [
                'score' => 'N/A',
                'grade' => 'N/A',
                'points' => 0
            ];
        }
    }

    // Calculate total points from the 7 smallest points
    sort($pointsArray);
    $smallestPoints = array_slice($pointsArray, 0, 7); // Pick the smallest 7 points
    $totalPoints = array_sum($smallestPoints);

    // Calculate division
    $averageScore = $totalScore / count($studentResults);
    $division = calculateDivision($totalPoints);

    // Placeholder for position (e.g., always 1st for simplicity)
    $position = 1;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin | View Student Results</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">

    <div class="container">
        <a class="navbar-brand" href="#">Results Management System</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item active">
                    <a class="nav-link" href="admin.php">Home</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="school_logout.php">Logout</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

    <br>
    <!-- Search Filters Form -->
    <div class="card mb-4">
         <div class="card-header bg-info text-white">
            <h3>Search Student Results</h3>
            <form method="GET" action="">
                <div class="row">
                    <div class="col-md-3">
                        <label for="registration_number" class="form-label">Registration Number</label>
                        <input type="text" name="registration_number" id="registration_number" class="form-control" placeholder="Enter registration number" value="<?php echo htmlspecialchars($registration_number); ?>" required>
                    </div>
                    <div class="col-md-3">
                        <label for="full_name" class="form-label">Full Name</label>
                        <input type="text" name="full_name" id="full_name" class="form-control" placeholder="Enter full name" value="<?php echo htmlspecialchars($full_name); ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="exam_type" class="form-label">Exam Type</label>
                        <select name="exam_type" id="exam_type" class="form-select" required>
                            <option value="">Select Exam Type</option>
                            <option value="Midterm_1_Examination" <?php echo ($exam_type == 'Midterm 1 Examination') ? 'selected' : ''; ?>>Midterm 1</option>
                            <option value="Terminal_Examination" <?php echo ($exam_type == 'Terminal Examination') ? 'selected' : ''; ?>>Terminal</option>
                            <option value="Midterm_2_Examination" <?php echo ($exam_type == 'Midterm 2 Examination') ? 'selected' : ''; ?>>Midterm 2</option>
                            <option value="Annual_Examination" <?php echo ($exam_type == 'Annual Examination') ? 'selected' : ''; ?>>Annual</option>
                            <option value="Mock_Examination" <?php echo ($exam_type == 'Mock Examination') ? 'selected' : ''; ?>>Mock</option>
                          
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="year" class="form-label">Year</label>
                        <select name="year" id="year" class="form-select" required>
                            <option value="">Select Year</option>
                            <?php 
                                for ($i = date('Y'); $i >= 2000; $i--) {
                                    echo "<option value='$i'" . ($year == $i ? 'selected' : '') . ">$i</option>";
                                }
                            ?>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary mt-3">Search</button>
            </form>
        </div>
    </div>

  <!-- Display Student Details -->
    <?php if ($resultsFound): ?>
    <!-- Display Student Details -->
<?php if ($resultsFound): ?>
<div class="card mb-4">
    <div class="card-header bg-info text-white">
        <h3 class="mb-0">Student Information</h3>
    </div>
    <div class="card-body">
        <div class="row">
            <!-- Full Name Column -->
            <div class="col-md-4 mb-3">
                <p><strong>Full Name:</strong></p>
                <p><?php echo htmlspecialchars($studentDetails['full_name']); ?></p>
            </div>

            <!-- Gender Column -->
            <div class="col-md-4 mb-3">
                <p><strong>Gender:</strong></p>
                <p><?php echo htmlspecialchars($studentDetails['gender']); ?></p>
            </div>

         
        </div>
    </div>
</div>



<!-- Results Summary Table -->
<div class="card mb-4">
    <div class="card-header bg-info text-white">
        <h3 class="mb-0">Results Summary</h3>
    </div>
    <div class="card-body">
        <?php if ($resultsFound): ?>
            <div class="row">
                <!-- Total Points -->
                <div class="col-md-6 mb-3">
                    <p><strong>Total Points:</strong></p>
                    <span class="badge bg-primary"><?php echo htmlspecialchars($totalPoints); ?></span>
                </div>

                <!-- Division -->
                <div class="col-md-6 mb-3">
                    <p><strong>Division:</strong></p>
                    <span class="badge <?php 
                        // Style division badges differently for each range
                        switch ($division) {
                            case 'I': echo 'bg-success'; break;
                            case 'II': echo 'bg-warning'; break;
                            case 'III': echo 'bg-danger'; break;
                            case 'IV': echo 'bg-secondary'; break;
                            default: echo 'bg-light'; break;
                        }
                    ?>"><?php echo htmlspecialchars($division); ?></span>
                </div>
            </div>

            <div class="row">
                <!-- Average Score -->
                <div class="col-md-6 mb-3">
                    <p><strong>Average Score:</strong></p>
                    <span class="badge bg-info"><?php echo number_format($averageScore, 2); ?></span>
                </div>

                <!-- Overall Grade -->
                <div class="col-md-6 mb-3">
                    <p><strong>Overall Grade:</strong></p>
                    <span class="badge <?php
                        // Apply styles based on the overall grade
                        $overallGrade = calculateGrade($averageScore, $gradeScale);
                        switch ($overallGrade[0]) {
                            case 'A': echo 'bg-success'; break;
                            case 'B': echo 'bg-primary'; break;
                            case 'C': echo 'bg-warning'; break;
                            case 'D': echo 'bg-danger'; break;
                            case 'F': echo 'bg-dark'; break;
                            default: echo 'bg-light'; break;
                        }
                    ?>"><?php echo $overallGrade[0]; ?></span>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-warning">No results found for the selected filters.</div>
        <?php endif; ?>
    </div>
</div>






<?php endif; ?>


       <div class="card mb-4">
    <div class="card-header bg-info text-white">
        <h3 class="mb-0">Results Summary</h3>
    </div>
                <?php if ($resultsFound): ?>
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Subject</th>
                                <th>Score</th>
                                <th>Grade</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($studentResults as $subject => $result): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($subject); ?></td>
                                    <td><?php echo is_numeric($result['score']) ? $result['score'] : 'N/A'; ?></td>
                                    <td><?php echo htmlspecialchars($result['grade']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                         
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="alert alert-warning">No results found for the selected filters.</div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

    
<!-- Footer -->
<footer class="footer mt-5 py-3 bg-light">
    <div class="container text-center">
        <span class="text-muted">&copy; <?php echo date('Y'); ?> Results Management System | Welcome, <?php echo htmlspecialchars($admin_username); ?></span>
    </div>
</footer>

<!-- Bootstrap 5 JS (required for responsive navbar toggling) -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.min.js"></script>
</body>
</html>
